﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using CgpibCs;
using CSubFuncCs;

namespace Sample
{
    class GPIB_CONTEC
    {
        // (0)クラス内変数
        private Cgpib Gpib = new Cgpib();
        private CSubFunc SubFunc = new CSubFunc();
        public uint MyAddress = 0;                                                      // マイアドレス
        private uint DeviceAddress = 0;                                                 // 機器アドレス
        public string MsgBuf = "";                                                      // 受信データ
        private GCHandle gChCmd;                                                        // Cmd配列用GCHandle

        // (1)接続
        public bool OpenInterface(string primaryAddress)
        {
            uint mode;
            uint eoi;
            uint delim;
            string message;
            uint ret;

            ret = (uint)SubFunc.GpibInit(out message);                                  // GPIBの初期化
            if (ret != 0)
            {
                MessageBox.Show(message);
                return false;
            }

            ret = Gpib.Boardsts(0x0a, out mode);                                        // マスタ/スレーブモードの読み出し
            if (ret != 0)
            {
                SubFunc.CheckRet("GpBoardsts", ret, out message);                       // 戻り値をチェック
                MessageBox.Show(message);
                return false;
            }
            if (mode != 0)
            {
                MessageBox.Show("This device is not MASTER. Please check your settings.");
                return false;
            }

            ret = Gpib.Boardsts(0x08, out MyAddress);                                   // マイアドレスの取得
            if (ret != 0)
            {
                SubFunc.CheckRet("GpBoardsts", ret, out message);                       // 戻り値をチェック
                MessageBox.Show(message);
                return false;
            }

            eoi = 1;                                                                    // 0:使用しない / 1:使用する
            delim = 3;                                                                  // 0:未使用 / 1:CR+LF / 2:CR / 3:LF
            ret = Gpib.Delim(delim, eoi);                                               // デリミタコード(EOI)送出の設定
            if (ret != 0)
            {
                SubFunc.CheckRet("GpDelim", ret, out message);                          // 戻り値をチェック
                MessageBox.Show(message);
                return false;
            }

            ret = Gpib.Timeout(10000);                                                  // タイムアウト設定
            if (ret != 0)
            {
                SubFunc.CheckRet("GpTimeout", ret, out message);                        // 戻り値をチェック
                MessageBox.Show(message);
                return false;
            }

            DeviceAddress = Convert.ToUInt32(primaryAddress);

            return true;
        }

        // (2)切断
        public bool CloseInterface()
        {
            SubFunc.GpibExit();                                                         // GPIBの終了

            return true;

        }

        // (3)コマンド送信
        public bool SendMsg(string strMsg)
        {
            int ret;

            ret = SubFunc.GpibPrint(DeviceAddress, strMsg);                             // 送信バッファに書き込み
            if (ret != 0)
            {
                return false;
            }

            return true;
        }

        // (4)受信
        public bool ReceiveMsg(uint timeout_ms)
        {
            string message;
            StringBuilder buf = new StringBuilder(8388608);
            uint ret;
            int ret2;

            ret = Gpib.Timeout(timeout_ms);
            if (ret != 0)
            {
                SubFunc.CheckRet("GpTimeout", ret, out message);                        // 戻り値をチェック
                MessageBox.Show(message);
                return false;
            }

            ret2 = SubFunc.GpibInputHioki(DeviceAddress, buf);                          // 受信バッファから読み取り
            if (ret2 != 0)
            {
                MsgBuf = "Error";
                return false;
            }
            MsgBuf = buf.ToString();                                                    // 受信データを保存

            return true;

        }

        // (5)コマンド送受信
        public bool SendQueryMsg(string strMsg, uint timeout_ms)
        {
            bool ret = false;

            ret = SendMsg(strMsg);                                                      // コマンド送信
            if (ret)
            {
                if (strMsg.Contains("?"))
                {
                    ret = ReceiveMsg(timeout_ms);                                       // 送信が成功したら応答を受信
                }
            }

            return ret;
        }
    }

}
